<?php
session_start();

// 包含配置
require_once __DIR__.'/../config.php';

// 如果已经登录，重定向到管理页面
if (isset($_SESSION['admin_loggedin'])) {  // 这里补全了右括号
    header('Location: dashboard.php');
    exit;
}

// 处理登录
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === $admin_credentials['username'] && $password === $admin_credentials['password']) {
        $_SESSION['admin_loggedin'] = true;
        header('Location: dashboard.php');
        exit;
    } else {
        $error = '用户名或密码错误！';
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>刀客源码导航 - 后台登录</title>
    <style>
        :root {
            --primary-color: #5CACEE;
            --primary-dark: #2a4e9a;
            --text-dark: #2a4e9a;
            --text-medium: #5a6b9c;
            --bg-light: #f8faff;
            --card-bg: white;
            --box-shadow: 0 8px 25px rgba(70, 110, 180, 0.12);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', 'Microsoft YaHei', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #f0f5ff, #e4ecff);
            color: #333;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .login-container {
            background: var(--card-bg);
            border-radius: 16px;
            box-shadow: var(--box-shadow);
            padding: 30px;
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        
        .logo {
            font-size: 28px;
            color: var(--primary-dark);
            font-weight: 700;
            margin-bottom: 25px;
        }
        
        h2 {
            color: var(--text-dark);
            margin-bottom: 25px;
        }
        
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: var(--text-medium);
            font-weight: 500;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #dce1e9;
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="password"]:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(92, 172, 238, 0.2);
            outline: none;
        }
        
        .btn {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: var(--transition);
        }
        
        .btn:hover {
            background: linear-gradient(135deg, #4a9fe3, #1d3e7a);
            transform: translateY(-2px);
        }
        
        .error {
            color: #FF6B6B;
            margin-top: 15px;
        }
        
        .copyright {
            margin-top: 25px;
            color: var(--text-medium);
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">🌬️ 刀客源码导航</div>
        <h2>后台管理系统</h2>
        <?php if ($error): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="form-group">
                <label for="username">用户名</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">密码</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn">登录</button>
        </form>
        <div class="copyright">© 2025 刀客源码导航</div>
    </div>
</body>
</html>